#! /bin/sh

# <codex>
# <abstract>Script to remove everything installed by the sample.</abstract>
# </codex>

# This uninstalls everything installed by the sample.  It's useful when testing to ensure that 
# you start from scratch.

if [ `whoami` = root ]; then
    echo "Please do not run this script as root or using sudo"
    exit
fi

bold=$(tput bold) normal=$(tput sgr0)

echo "${bold}Removing kext, if installed...${normal}"
sudo kextunload -b com.MagnetismStudios.cputune

echo "${bold}Quitting helper tool...${normal}"
sudo launchctl unload /Library/LaunchDaemons/com.MagnetismStudios.endurance.helper.plist
sudo security -q authorizationdb remove "com.MagnetismStudios.endurance.readLicenseKey"
sudo security -q authorizationdb remove "com.MagnetismStudios.endurance.writeLicenseKey"
sudo security -q authorizationdb remove "com.MagnetismStudios.endurance..startWebService"
sudo rm -f /Library/LaunchDaemons/com.MagnetismStudios.endurance.helper.plist
sudo rm -f /Library/PrivilegedHelperTools/com.MagnetismStudios.endurance.helper

echo "${bold}Removing preference pane...${normal}"
rm -rf ~/Library/PreferencePanes/Endurance.prefpane/
echo "Done"

echo "${bold}Removing user defaults...${normal}"
defaults delete com.MagnetismStudios.endurance 2> /dev/null
defaults delete com.magnetism.endurance-setapp 2> /dev/null
echo "Done"

# echo "${bold}Quitting Endurance...${normal}"
# sudo killall Endurance
